string GetDescription()
{
	return "Drums - generates a randomized drum pattern in a dance style";
}

struct Pattern
{
	double Length;
	int[] Pitches;	
	int velfrom;
	int velto;
	double[] pattern;
};

Pattern NewPattern(double l, int[] pit, double[] pat, int v1, int v2)
{
	Pattern p;
	p.Length = l;
	p.Pitches = pit;
	p.pattern = pat;
	p.velfrom = v1;
	p.velto = v2;
	return p;	
}

void RealizePattern(RenderPart @p, Pattern pat)
{
	for (int i = p.GetStartBar(); i < p.GetEndBar(); i++)
	{
		for (double m = 0; m < p.GetUniquePart().GetMetrum(); m+=pat.Length)
		{
			for (uint n = 0; n < pat.pattern.length(); n++)
			{
				if (pat.pattern[n] + m < p.GetUniquePart().GetMetrum())
				{
					for (uint q = 0; q < pat.Pitches.length(); q++)
						p.AddPercNote( CreateTime(i, m+pat.pattern[n]), CreateTime(i, m+pat.pattern[n]+0.1), pat.Pitches[q], RndInt(pat.velfrom,pat.velto));
				}	
			}
		}
	}	
}

void Render(RenderPart @p)
{
	Pattern[] patterns(50);
	
	int w = 0;
	
	int[] pit1 = {35,36}; double[] pat1 = {0};
	patterns[w++] = NewPattern(1, pit1, pat1, 119, 120);

	if (RndInt(0,1) == 0)
	{
		int[] pit3 = {35,36 }; 
		double[] pat3 = { 0.5+RndInt(0,3) };
		patterns[w++] = NewPattern(4, pit3, pat3, 115, 116);
		
	}
	
	
	if (RndInt(0,2) != 0)
	{
		int[] p_pit = { 52,40,41,48,53,55,56,62,64 };
		int[] pit2 = {p_pit[RndInt(0,p_pit.length()-1)]}; double[] pat2 = {1+RndInt(-1,1)*0.5};
		patterns[w++] = NewPattern(2, pit2, pat2, 100, 110);
		
		int[] pit3 = {38,39 }; double[] pat3 = {RndInt(0,1)};
		patterns[w++] = NewPattern(2, pit3, pat3, 100, 110);
	}
	
	if (p.GetTempo() < 90)
	{
		for (int i = 0; i < w; i++)
		{
			patterns[i].Length /= 2.0;
			for (int y = 0; y < patterns[i].pattern.length(); y++)
				patterns[i].pattern[y] /= 2.0;
		}
	}
	
	if (p.GetTempo() > 199)
	{
		for (int i = 0; i < w; i++)
		{
			patterns[i].Length *= 2.0;
			for (int y = 0; y < patterns[i].pattern.length(); y++)
				patterns[i].pattern[y] *= 2.0;
		}
	}
	
	
	for (int i = 0; i < w; i++)
		RealizePattern(p, patterns[i]);	
}